/*******************************************************************************
 * Copyright (c) Dino Octavian.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution, and is available at
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *  
 *  Contributors:
 *      Dino Octavian - initial API and implementation
 *******************************************************************************/
package gloodb;

/**
 * Thrown when data encryption / decryption fails. This may occur when writing
 * to transaction logs or when flushing data into the file storage.
 */
public class EncryptionException extends GlooException {
	private static final long serialVersionUID = -6219576466643702194L;

	/**
	 * Creates an exception object with null as a detailed message and cause.
	 */
	public EncryptionException() {
		super();
	}

	/**
	 * Creates an exception object with a detailed message.
	 * 
	 * @param message
	 *            The detail message.
	 */
	public EncryptionException(String message) {
		super(message);
	}

	/**
	 * Creates an exception object with a detailed message and a cause.
	 * 
	 * @param message
	 *            The detail message.
	 * @param cause
	 *            The cause of this exception.
	 */
	public EncryptionException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Creates an exception object with a cause.
	 * 
	 * @param cause
	 *            The cause of this exception.
	 */
	public EncryptionException(Throwable cause) {
		super(cause);
	}
}
